---
Note type: Reference
tags:
  - ZoteroReference
Reference type: "journalArticle"
Bib_ref: "Cooper D (2020) Towards an adventurous institutional politics: the prefigurative ‘as if’ and the reposing of what’s real. _Sociological Review_ 68(5). SAGE Publications Ltd: 893–916."
Title: "Towards an adventurous institutional politics: the prefigurative ‘as if’ and the reposing of what’s real"
Year: "2020-09-01T00:00:00+01:00"
Journal-publisher: "Sociological Review"
Related areas:
  - "[[Research]]"
Related projects: 
Related tasks: 
Related references: 
Related zettels: 
Related meeting notes: 
Related resources: 
Related people: 
aliases:
  - '"Towards an adventurous institutional politics"'
Creation date: "2024-04-19T16:51:01+01:00"
Read: Read
---

# Item notes from Zotero

Open in Zotero: [SAGE PDF Full Text](zotero://select/library/items/TJUWQUVR)
Related references:

- [[Yates 2015]]

## Overview

### Context

 “Discussion of prefigurative politics typically focuses on the revisioning of means to ends within grass-roots activities taking shape against or apart from the state. This article takes a different approach.” ([[Cooper 2020]], p. 893)

### Aim

to explore prefiguration as “the assertion of counterhegemonic meanings, facts, norms and authority both by and about institutions, including state ones.” ([[Cooper 2020]], p. 893)

### RQ

what can prefiguration, and reading for prefiguration, “contribute to a progressive transformative politics”? ([[Cooper 2020]], p. 893)

### Thesis

Prefiguration should not be considered as something that can only ever take place outside of the state - indeed there are types of prefiguration that specifically engage with the state and similar institutions: [[institutional prefiguration]]

 “state and other institutions, as socio-political assemblages, should not be discounted when it comes to prefigurative practice” ([[Cooper 2020]], p. 894)

The promise of prefiguration is fundamentally tied to its “quality of being both real and not real, in conditions of wider opposition, support and torpidity” ([[Cooper 2020]], p. 893)

### Theoretical framing

Understands [[prefiguration]] in terms of ‘as if’

### Methodology

 “four contentious acts:” ([[Cooper 2020]], p. 893)

-  “municipal expressions of international solidarity;”
-  “legislating new gender categories;”
-  “role-playing micro-states and new money”
-  “acting like a law reform commission”

Empirical focus of the paper: British institutions of:

- state
- law
- money
- gender

 “chosen for their interconnections as well as their differences, and for their capacity to be prefigured in the sense of embodying new, socially preferred norms and values.” ([[Cooper 2020]], p. 894)

### Findings

### Contributions

### Striking points

### Further research suggested

### My ideas/responses

### Useful references

---

## Fleeting notes

[[2024-03-19]] - [[Davina Cooper]] sent me this reference directly in responding to my Two Routes paper.

---

## Summary

### [[prefiguration]]

- “Moving beyond an incremental stretching or tinkering with present practice, prefiguration aims to bring into being changes that seem right or at least preferable” with a  “focus on doings and enactments” ([[Cooper 2020]], p. 894)
- Well-recognized attributes of prefiguration: ([[Cooper 2020]], p. 893)

    - rehearsing alternatives
    - anticipating alternatives
    - representing alternatives
- Less well-recognized attributes of prefiguration - which are particularly prominent in the case of [[institutional prefiguration]] ([[Cooper 2020]], p. 893)

    - Retroactively constituting its own “conditions of legitimacy and authority”
    - Retroactively constituting its own  “depiction as fiction”
    - Retroactively constituting “the performative constraints it faces from diffuse and unequal circuits of power”
    - The  “work done by recognition (and non-recognition) of new facts, rules and norms”

### [[institutional prefiguration]]

-  “state and other institutions, as socio-political assemblages, should not be discounted when it comes to prefigurative practice” ([[Cooper 2020]], p. 894)
- State and other institutions are “necessary sites for transformative action” ([[Cooper 2020]], p. 894) due to:

    - “Their social pervasiveness and taken-for-grantedness”
    - “their formative and ordering capacity”
    - “their power”
    - “their plasticity and agency”
- But  “these qualities make institutions challenging change-subjects as well” ([[Cooper 2020]], p. 894)
- [[Institutions]]:

    -  “durable, patterned processes and formations, tying together rules, procedures, norms, systems, knowledges, temporalities, spaces, things, moralities and people in ways that are meaningful, forceful and with effects.” ([[Cooper 2020]], p. 894)
    -  “They evolve and change; are plural, heterogeneous, and contradictory; and can be counter-cultural and hybrid as work on **critical institutionalism** also explores (e.g. Cleaver & de Koning, 2015).” ([[Cooper 2020]], p. 894)

---

## Miscellaneous points